using System;
using System.Collections.Generic;

namespace Stack
{
	public class Tester
	{
		static void Main()
		{
			Stack<Int32> intStack = new Stack<Int32>();

			// Zapenianie tablicy 

			for (int i = 0; i < 8; i++)
			{
				intStack.Push(i * 5);
			}


			// Wywietlanie stosu
			Console.Write("Wartoci stosu intStack:\t");
			PrintValues(intStack);

			// Usuwanie elementu ze stosu
			Console.WriteLine("\n(Pop)\t{0}",
			intStack.Pop());

			// Wywietlanie stosu
			Console.Write("Wartoci stosu intStack:\t");
			PrintValues(intStack);

			// Usuwanie ze stosu nastpnego elementu
			Console.WriteLine("\n(Pop)\t{0}",
			intStack.Pop());

			// Wywietlanie stosu
			Console.Write("Wartoci stosu intStack:\t");
			PrintValues(intStack);

			// Wywietlanie pierwszego elementu stosu
			// bez usuwania go
			Console.WriteLine("\n(Peek) \t{0}",
			   intStack.Peek());


			// Wywietlanie stosu
			Console.Write("Wartoci stosu intStack:\t");
			PrintValues(intStack);

			// Deklaracja obiektu przechowujcego
			// 12 liczb cakowitych
			int[] targetArray = new int[12];

			for (int i = 0; i < targetArray.Length; i++)
			{
				targetArray[i] = i * 100 + 100;
			}

			// Wywietlanie elementw tablicy targetArray
			Console.WriteLine("\nTablica targetArray: ");
			PrintValues(targetArray);

			// Kopiowanie caej zawartoci stosu do
			// tablicy targetArray, poczwszy od indeksu 6
			intStack.CopyTo(targetArray, 6);


			// Wywietlanie wartoci tablicy targetArray
			Console.WriteLine("\nTablica targetArray po kopiowaniu: ");
			PrintValues(targetArray);

		}

		public static void PrintValues(
		   IEnumerable<Int32> myCollection)
		{
			IEnumerator<Int32> enumerator =
			   myCollection.GetEnumerator();
			while (enumerator.MoveNext())
				Console.Write("{0} ", enumerator.Current);
			Console.WriteLine();
		}
	}
}
